<?php
require 'config_livescores2024.php';

// Sélectionnez les données de votre table
$sql = "SELECT b.ligne AS concu,r.juge, r.note,r.vague,if(nbrenotes>=nbrejuges,format(av.moyenne/(nbrenotes-2),2),'-') AS moyenne,m.valide, rv.`name` FROM resu r LEFT JOIN moyennes_valides m ON r.serie=m.serie AND r.concu=m.concu AND r.vague=m.vague
LEFT JOIN 
(SELECT serie,concu,vague,count(note) as nbrenotes,SUM(note)-MAX(note)-MIN(note) AS moyenne FROM resu GROUP BY serie,concu,vague) av
ON r.serie=av.serie AND r.concu=av.concu AND r.vague=av.vague
JOIN (SELECT valeur AS nbrejuges FROM parametres WHERE `option`='nbrejuges' ) p ON 1=1
LEFT JOIN 
bloque b ON b.concu=r.concu
LEFT JOIN replay.videos rv ON rv.`row`=b.ligne AND r.vague=rv.col
WHERE r.serie IN (SELECT serie FROM bloque) 
ORDER BY concu,vague,juge ;
 ";

$result = $conn->query($sql);

// Vérifier s'il y a des résultats
if ($result->num_rows > 0) {
    // Créer un tableau associatif pour stocker les résultats
    $data = array();

    // Parcourir chaque ligne de résultat
    while ($row = $result->fetch_assoc()) {
        // Ajouter chaque ligne au tableau
        $data[] = $row;
    }

    // Encoder le tableau en JSON
    $jsonData = json_encode($data);

    // Afficher le JSON
    echo $jsonData;
} else {
    echo "Aucun résultat trouvé";
}

// Fermer la connexion
$conn->close();
?>
