<?php
// Connexion à la base de données MySQL
require 'config_livescores2024.php';


// Récupérer les données envoyées en JSON
$data = json_decode(file_get_contents('php://input'), true);
$ligne = $data['ligne'];
$serie = $data['serie'];
$rank = $data['rank'];
$total = $data['total'];
    
// Vérifier si les données nécessaires sont présentes
if (isset($serie)) {
    //$serie = $data['serie'];

        // Insérer les nouvelles données à partir de la jointure entre bloque et heats
        $stmt = $conn->prepare("
            UPDATE heats h INNER JOIN resu r ON h.serie=r.serie AND h.concu=r.concu SET rank = ? , total = ?
            WHERE h.ligne = ? and h.serie = ?
        ");
        $stmt->bind_param('idii', $rank, $total, $ligne, $serie);
        if ($stmt->execute()) {
            echo json_encode(['success' => true, 'action' => 'updated']);
             
        
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
        }
    

    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Données manquantes']);
}

$conn->close();

?>