<?php
header('Content-Type: application/json');

// Check if the request method is POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Get the raw POST data
    $input = json_decode(file_get_contents('php://input'), true);

    // Check if all required parameters are set
    if (isset($input['action']) && isset($input['serie']) && isset($input['concu']) && isset($input['wave'])) {

        // Sanitize the input
        $action = htmlspecialchars($input['action']);
        $serie = intval($input['serie']);
        $concu = intval($input['concu']);
        $wave = intval($input['wave']);
        $juge = 0;
        
        // Create a response array to store the result
        $response = array('status' => '', 'message' => '');

        // Connexion à la base de données MySQL
require 'config_livescores2024.php';



     // SQL query based on action
$query = '';

switch ($action) {
    case 'REMOVE INTERFERENCE':
        // Remove interference by deleting the entry for a specific series, competitor, and wave
        $query = "DELETE FROM resu WHERE serie = ? AND concu = ? AND vague = ? AND juge = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('iiii', $serie, $concu, $wave, $juge);
        break;

    case 'INTERFERENCE IN':
        // Insert or update interference (setting note to 12)
        $query = "INSERT INTO resu (serie, concu, vague, juge, note) VALUES (?, ?, ?, ?, 11) ON DUPLICATE KEY UPDATE note = 11";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('iiii', $serie, $concu, $wave, $juge);
        break;

    case 'PRIORITY IN':
        // Insert or update priority (setting note to 14)
        $query = "INSERT INTO resu (serie, concu, vague, juge, note) VALUES (?, ?, ?, ?, 14) ON DUPLICATE KEY UPDATE note = 14";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('iiii', $serie, $concu, $wave, $juge);
        break;

    default:
        $response['status'] = 'error';
        $response['message'] = 'Invalid action';
        echo json_encode($response);
        exit();
}

// Prepare and execute the SQL query
if ($stmt) {
    if ($stmt->execute()) {
        $response['status'] = 'success';
        $response['message'] = 'Action executed successfully';
    } else {
        $response['status'] = 'error';
        $response['message'] = 'Failed to execute action: ' . $stmt->error;
    }
    $stmt->close();
} else {
    $response['status'] = 'error';
    $response['message'] = 'Failed to prepare statement: ' . $conn->error;
}



        // Close the database connection
        $conn->close();
        echo json_encode($response);

    } else {
        echo json_encode(array('status' => 'error', 'message' => 'Missing parameters.'));
    }

} else {
    echo json_encode(array('status' => 'error', 'message' => 'Invalid request method.'));
}
?>
