<?php
// Définition de la classe Competitor
class Competitor {
    public $id;
    public $name;
    public $score = 0;

    public function __construct($id, $name) {
        $this->id = $id;
        $this->name = $name;
    }
}

// Définition de la classe Heat
class Heat {
    public $id;
    public $competitors = [];
    public $maxCompetitors;

    public function __construct($id, $maxCompetitors) {
        $this->id = $id;
        $this->maxCompetitors = $maxCompetitors;
    }

    public function addCompetitor(Competitor $competitor) {
        if (count($this->competitors) < $this->maxCompetitors) {
            $this->competitors[] = $competitor;
        } else {
            throw new Exception("Le heat {$this->id} est plein.");
        }
    }

    public function getWinners($numberOfWinners) {
        // Trier les compétiteurs par score décroissant
        usort($this->competitors, function($a, $b) {
            return $b->score - $a->score;
        });
        // Retourner les meilleurs compétiteurs
        return array_slice($this->competitors, 0, $numberOfWinners);
    }
}

// Définition de la classe Round
class Round {
    public $id;
    public $heats = [];

    public function __construct($id) {
        $this->id = $id;
    }

    public function addHeat(Heat $heat) {
        $this->heats[] = $heat;
    }
}

// Fonction pour générer un nombre aléatoire de compétiteurs par heat entre 2 et 5
function getRandomCompetitorsPerHeat() {
    return rand(2, 5);
}

// Initialisation des compétiteurs
$totalCompetitors = 30; // Nombre total de compétiteurs
$competitors = [];
for ($i = 1; $i <= $totalCompetitors; $i++) {
    $competitors[] = new Competitor($i, "Compétiteur $i");
}

// Paramètres du tournoi
$numberOfWinnersPerHeat = 2; // Nombre de compétiteurs qui se qualifient par heat

// Organisation du tournoi
$roundNumber = 1;
$currentCompetitors = $competitors;
$tournament = [];

while (count($currentCompetitors) > 1) {
    echo "======== Tour $roundNumber ========\n";
    $round = new Round($roundNumber);

    // Déterminer le nombre de compétiteurs par heat pour ce tour
    $maxCompetitorsPerHeat = getRandomCompetitorsPerHeat();
    echo "Nombre de compétiteurs par heat pour ce tour : $maxCompetitorsPerHeat\n";

    // Calcul du nombre de heats nécessaires
    $numberOfHeats = ceil(count($currentCompetitors) / $maxCompetitorsPerHeat);
    echo "Nombre de heats pour ce tour : $numberOfHeats\n";

    // Mélanger les compétiteurs pour une répartition aléatoire
    shuffle($currentCompetitors);

    // Diviser les compétiteurs en heats
    $chunks = array_chunk($currentCompetitors, $maxCompetitorsPerHeat);

    foreach ($chunks as $index => $chunk) {
        $heat = new Heat($index + 1, $maxCompetitorsPerHeat);
        foreach ($chunk as $competitor) {
            $heat->addCompetitor($competitor);
        }
        $round->addHeat($heat);
    }

    // Simuler les résultats et déterminer les qualifiés
    $qualifiedCompetitors = [];
    foreach ($round->heats as $heat) {
        // Simuler les scores pour chaque compétiteur
        foreach ($heat->competitors as $competitor) {
            $competitor->score = rand(0, 100); // Simuler un score entre 0 et 100
        }
        // Obtenir les qualifiés
        $winners = $heat->getWinners($numberOfWinnersPerHeat);
        $qualifiedIds = array_map(function($comp) {
            return $comp->id;
        }, $winners);

        // Afficher les résultats par ligne
        foreach ($heat->competitors as $competitor) {
            $isQualified = in_array($competitor->id, $qualifiedIds) ? 'Oui' : 'Non';
            echo "Tour {$round->id} | Heat {$heat->id} | {$competitor->name} | Score: {$competitor->score} | Qualifié: $isQualified\n";
        }
        echo "\n"; // Ligne vide pour séparer les heats

        // Ajouter les qualifiés pour le tour suivant
        $qualifiedCompetitors = array_merge($qualifiedCompetitors, $winners);
    }

    // Ajouter le tour au tournoi
    $tournament[] = $round;

    // Préparer les compétiteurs pour le tour suivant
    $currentCompetitors = $qualifiedCompetitors;
    $roundNumber++;
}

// Déterminer le vainqueur ou les vainqueurs
if (count($currentCompetitors) == 1) {
    $winner = $currentCompetitors[0];
    echo "Le vainqueur du tournoi est : " . $winner->name . "\n";
} else {
    echo "Les vainqueurs sont : \n";
    foreach ($currentCompetitors as $competitor) {
        echo $competitor->name . "\n";
    }
}
?>
