<?php
// /includes/get_ecart.php

function getEcartPondere($conn) {
    $sql = "
       SELECT serie, nomjuge,concu,vague,note,moyen,abs(moyen-note) AS ecart from

(SELECT 
                        resu.serie,
                        concu,
                        juge,
                        
                        vague, 
                        note,
                        MIN(note) AS minot, 
                        MAX(note) AS maxnote, 
                        CASE 
                            WHEN COUNT(note) > 2 THEN ROUND((SUM(note) - MAX(note) - MIN(note)) / (COUNT(note) - 2), 2) 
                            ELSE 0 
                        END AS moyen
                    FROM resu
                    GROUP BY serie, concu, vague) t
                  LEFT JOIN juges ON juges.idjuge=t.juge
                    WHERE abs(moyen-note)>1 AND juge>0
                    ORDER BY ecart desc
    ";

    $result = $conn->query($sql);

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = [
            'nomjuge' => $row['nomjuge'],
            'serie' => $row['serie'],
            'vague' => $row['vague'],
            'note' => $row['note'],
            'moyenne' => $row['moyen'],
            'ecart' => $row['ecart']
        ];
    }

    return $data;
}
?>
