<?php
// /includes/get_judge_scores.php

function get_judge_scores($conn) {
    $sql = "
        SELECT 
            n.juge,
            j.nomjuge,
            n.serie,
            n.note
        FROM 
            resu n
        JOIN 
            juges j ON n.juge = j.idjuge
        ORDER BY 
            n.serie, n.juge
    ";
    
    $result = $conn->query($sql);
    
    $data = [];
    
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $juge = $row['nomjuge'];
            $serie = $row['serie'];
            $note = $row['note'];
            
            if (!isset($data[$juge])) {
                $data[$juge] = [];
            }
            $data[$juge][$serie] = $note;
        }
    }
    
    return $data;
}
?>
