<?php
// /includes/get_sequences.php

function getSequences($conn) {
    // Initialiser les variables utilisateur
    $conn->query("SET @rn := 0, @prev_juge := '', @prev_serie := 0, @grp := 0;");

    $sql = "
        SELECT 
            j.nomjuge,
            s.juge,
            SUM(s.longueur_sequence) AS total_heats,
            MAX(s.longueur_sequence) AS longest_sequence
        FROM (
            SELECT 
                juge,
                grp,
                COUNT(*) AS longueur_sequence
            FROM (
                SELECT 
                    juge,
                    serie,
                    (@rn := IF(@prev_juge = juge AND serie = @prev_serie + 1, @rn + 1, 1)) AS rn,
                    (@prev_juge := juge) AS current_juge,
                    (@prev_serie := serie) AS current_serie,
                    (serie - @rn) AS grp
                FROM (
                    SELECT DISTINCT juge, serie
                    FROM resu
                    ORDER BY juge, serie
                ) AS sorted_resu
                CROSS JOIN (SELECT @rn := 0, @prev_juge := '', @prev_serie := 0) AS vars
            ) AS t
            GROUP BY 
                juge, grp
        ) AS s
        JOIN juges j ON s.juge = j.idjuge
        GROUP BY 
            s.juge, j.nomjuge
        ORDER BY 
            total_heats DESC;
    ";

    $result = $conn->query($sql);

    $data = [];
    while ($row = $result->fetch_assoc()) {
        $data[] = [
            'nomjuge' => $row['nomjuge'],
            'juge' => $row['juge'],
            'total_heats' => $row['total_heats'],
            'longest_sequence' => $row['longest_sequence']
        ];
    }

    return $data;
}
?>
