document.getElementById('image-input').addEventListener('change', function(event) {
    const imageFile = event.target.files[0];
    if (imageFile) {
        processImage(imageFile);
    }
});

function processImage(imageFile) {
    const reader = new FileReader();
    reader.onload = function(event) {
        const img = new Image();
        img.src = event.target.result;

        img.onload = function() {
            const targetSize = 300;
            const canvas = document.getElementById('image-canvas');
            const ctx = canvas.getContext('2d');

            canvas.width = targetSize;
            canvas.height = targetSize;

            if (img.height > img.width) {
                const cropHeight = img.width;
                const cropStartY = 0;

                ctx.drawImage(
                    img,
                    0, cropStartY, img.width, cropHeight,
                    0, 0, targetSize, targetSize
                );
            } else {
                const scale = Math.max(targetSize / img.width, targetSize / img.height);
                const newWidth = img.width * scale;
                const newHeight = img.height * scale;

                const offsetX = (targetSize - newWidth) / 2;
                const offsetY = (targetSize - newHeight) / 2;

                ctx.drawImage(img, offsetX, offsetY, newWidth, newHeight);
            }

            // Chroma key pour enlever la couleur spécifique (rgb(37, 150, 190))
            const imageData = ctx.getImageData(0, 0, canvas.width, canvas.height);
            const data = imageData.data;

            // Valeurs RGB de la couleur cible à supprimer
            const targetR = 23;
            const targetG = 173;
            const targetB = 96;
            const tolerance = 65;  // Ajustez la tolérance si nécessaire

            for (let i = 0; i < data.length; i += 4) {
                const r = data[i];
                const g = data[i + 1];
                const b = data[i + 2];

                // Vérifier si la couleur correspond à la cible avec une tolérance
                if (Math.abs(r - targetR) < tolerance && Math.abs(g - targetG) < tolerance && Math.abs(b - targetB) < tolerance) {
                    data[i + 3] = 0;  // Appliquer la transparence
                }
            }

            ctx.putImageData(imageData, 0, 0);

            // Convertir en image data URL pour l'upload
            const finalImage = canvas.toDataURL('image/png');
            document.getElementById('preview').src = finalImage;
        };
    };
    reader.readAsDataURL(imageFile);
}

document.getElementById('image-form').addEventListener('submit', function(event) {
    event.preventDefault();

    const canvas = document.getElementById('image-canvas');
    const selectedName = document.getElementById('name-select').value;

    canvas.toBlob(function(blob) {
        const formData = new FormData();
        formData.append('image', blob, selectedName + '.png');
        formData.append('name', selectedName);  // Ajouter le nom sélectionné

        uploadImage(formData);
    });
});

function uploadImage(formData) {
    fetch('photo_submit.php', {
        method: 'POST',
        body: formData
    })
    .then(response => response.text())
    .then(data => {
        console.log('Image uploadée avec succès:', data);
        alert('Upload réussi !');
    })
    .catch(error => {
        console.error('Erreur lors de l\'upload:', error);
        alert('Erreur lors de l\'upload.');
    });
}
