<?php

// Initialisation des variables
$FG1 = [
    [8, 1, 32, 4, 2],
    [4, 0, 0, 4, 2],
    [2, 0, 0, 4, 2],
    [1, 0, 0, 4, 2]
];

$codeascii = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz@&é!çà#-$%£/?"; // Chaîne d'exemple
$som = intval($FG1[0][0] + 1); // Initialiser 'som' à partir de la première ligne, première colonne
$result = []; // Tableau pour stocker les données des deux scripts
$heats = array_fill(0, 100, 0);
$lignes = array_fill(0, 100, 0);

$Z = 0;
$sour = "";
$sourlig = "";
$heatsource = "";
$lignesource = "";

// Boucle pour le premier script
for ($i = 1; $i < count($FG1); $i++) {
    for ($x = 1; $x <= intval($FG1[$i][0]); $x++) {
        $start = (intval($FG1[$i][2]) + 1 - intval($FG1[$i][1])) / intval($FG1[$i][0]);
        if ($start < 2) {
            $start = 0;
        }

        if ($i > 1) {
            $endJ = (intval($FG1[$i - 1][4]) * intval($FG1[$i - 1][0])) / intval($FG1[$i][0]);
        } else {
            $endJ = intval($FG1[$i][3]) - $start;
        }

        for ($J = 1; $J <= $endJ; $J++) {
            $ligne = $J + $start;
            $serieCharacter = substr($codeascii, $som - 1, 1);

            // Ajouter la série et la ligne dans le tableau $result (fusionner avec le second script ensuite)
            $result[] = [
                'Dest' => $serieCharacter,
                'Destlig' => $ligne,
                'Heat' => null,   // Placeholder pour Heat
                'Ligne' => null   // Placeholder pour Ligne
            ];

            $som++;
        }
    }
}

// Boucle pour le deuxième script (ajout des données Heat et Ligne)
for ($I = 0; $I <= 2; $I++) {
    if (intval($FG1[$I + 1][4]) != 0) {
        $X1 = intval($FG1[$I][0]) / intval($FG1[$I + 1][4]);
        $x = ($X1 < 2) ? 2 : $X1;
    } else {
        $x = intval($FG1[$I][3]);
    }

    for ($NBRE = 1; $NBRE <= 2; $NBRE++) {
        if ($NBRE == 1) {
            $deb = 1;
            if (intval($FG1[$I][0]) > 1) {
                $fin = intval($FG1[$I][0]) / 2;
                $fin = ($fin - intval($fin) > 0) ? intval($fin) + 1 : intval($fin);
            } else {
                $fin = intval($FG1[$I][0]);
            }
        } else {
            $deb = (intval($FG1[$I][0]) / 2) + 1;
            $fin = intval($FG1[$I][0]);
        }

        for ($J = $deb; $J <= $fin; $J++) {
            $Z++;
            $sour .= "," . ($som + 1);
            $heats[$Z] = $som + 1;
            $x = 0;
            $nbreq = intval($FG1[$I][4]);

            if ($x == 0) {
                $sourlig .= (($Z - 1) % $nbreq) + 1;
                $lignes[$Z] = (($Z - 1) % $nbreq) + 1;
            } else {
                $sourlig .= 1;
                $lignes[$Z] = 1;
            }

            // Ajouter les données Heat et Ligne dans le tableau $result
            if (isset($result[$Z - 1])) {
                $result[$Z - 1]['Heat'] = $heats[$Z];
                $result[$Z - 1]['Ligne'] = $lignes[$Z];
            }

            $som++;
            $heatsource .= $FG1[$I][0] . ";";
        }

        if (intval($FG1[$I][4]) == 2) {
            for ($J = $fin; $J >= $deb; $J--) {
                $Z++;
                $som--;
                $sour .= "," . ($som + 1);
                $heats[$Z] = $som + 1;
                $x = 0;
                $nbreq = intval($FG1[$I][4]);

                if ($x == 0) {
                    $sourlig .= (($Z - 1) % $nbreq) + 1;
                    $lignes[$Z] = (($Z - 1) % $nbreq) + 1;
                } else {
                    $sourlig .= 1;
                    $lignes[$Z] = 1;
                }

                if (isset($result[$Z - 1])) {
                    $result[$Z - 1]['Heat'] = $heats[$Z];
                    $result[$Z - 1]['Ligne'] = $lignes[$Z];
                }
            }
            $som += intval($FG1[$I][0]) / 2;
        }
    }
    $lignesource .= $FG1[$I][0] . ";";
}

// Affichage des résultats dans un tableau HTML
echo "<h2>Résultats Fusionnés</h2>";
echo "<table border='1'><tr><th>Dest</th><th>Destlig</th><th>Heat</th><th>Ligne</th></tr>";
foreach ($result as $row) {
    echo "<tr>
            <td>{$row['Dest']}</td>
            <td>{$row['Destlig']}</td>
            <td>{$row['Heat']}</td>
            <td>{$row['Ligne']}</td>
          </tr>";
}
echo "</table>";

?>
