<?php
include_once 'auth.php';

// Connexion à la base de données MySQL avec MySQLi
require 'config_livescores2024.php'; // Assure-toi que ce fichier contient bien la connexion MySQLi et la variable $conn

// Vérifier si le formulaire a été soumis
if (isset($_POST['submit'])) {
    
    
    if (isset($_POST['compet_category'])) {
    $category_id = $_POST['compet_category'];
   
  
    
    
    // Vérifier si un fichier a été téléchargé et que c'est bien un fichier CSV
    if (is_uploaded_file($_FILES['file']['tmp_name']) && mime_content_type($_FILES['file']['tmp_name']) === 'text/plain') {
        $fileName = $_FILES['file']['tmp_name'];

        // Ouvrir le fichier CSV en mode lecture
        if (($handle = fopen($fileName, 'r')) !== false) {
            // Lire la première ligne (en-tête du fichier)
            $header = fgetcsv($handle, 1000, ';');
            
            // Vérifier que les colonnes correspondent bien aux colonnes attendues
            if ($header === ['nom', 'club']) {
                // Démarrer une transaction manuellement
                mysqli_query($conn, "START TRANSACTION");

                try {
                    
                    $stmt = $conn->prepare("DELETE from concu where categ= ?");
                    $stmt->bind_param('s', $category_id);
                    $stmt->execute();
                    // Boucle pour lire chaque ligne du fichier CSV
                    while (($data = fgetcsv($handle, 1000, ';')) !== false) {
                        // Préparer la requête SQL pour insérer les données dans la table
                        $stmt = $conn->prepare("INSERT INTO concu (categ, nom, club) VALUES (?, ?, ?)");

                        // Lier les données CSV à la requête SQL
                        $stmt->bind_param('sss', $category_id, $data[0], $data[1]);

                        // Exécuter la requête SQL
                        if (!$stmt->execute()) {
                            throw new Exception("Erreur lors de l'exécution de la requête");
                        }
                    }

                    // Valider la transaction
                    mysqli_query($conn, "COMMIT");
                    fclose($handle);
                    echo "Importation réussie !";

                } catch (Exception $e) {
                    // Annuler la transaction en cas d'erreur
                    mysqli_query($conn, "ROLLBACK");
                    fclose($handle);
                    echo "Erreur lors de l'importation : " . $e->getMessage();
                }
            } else {
                echo "Le format du fichier CSV est incorrect.";
            }
        } else {
            echo "Erreur lors de l'ouverture du fichier.";
        }
    } else {
        echo "Aucun fichier valide n'a été téléchargé.";
    }
     } else {
        echo "Aucune Categorie n'est sélectionnée.";
        
    }
}
?>
