<?php
include_once 'auth.php';

header('Access-Control-Allow-Origin: *'); // Allow all domains. Adjust if you want to be more restrictive
//header('Content-Type: application/json'); // Set appropriate content type for JSON data

require 'config_livescores2024.php';

// Récupération des données
$category = $_GET['category'];
$round = $_GET['round'];

$sql = "SELECT DISTINCT serie, heat
FROM heats h
WHERE categ= ? AND ROUND= ?
ORDER BY heat";
$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $category, $round);
$stmt->execute();
$result = $stmt->get_result();

// Transformation des données
$heatsData = [];
while ($row = $result->fetch_assoc()) {
    $serie = $row['serie'];
    $heat = $row['heat'];

    if (!isset($heatsData[$serie])) {
        $heatsData[$serie] = [];
    }

    if (!isset($heatsData[$serie][$heat])) {
        $heatsData[$serie][$heat] = [];
    }

   
}

$stmt->close();
$conn->close();

// Envoyer les données en JSON
echo json_encode($heatsData, JSON_PRETTY_PRINT);
?>