<?php
include_once 'auth.php';

header('Access-Control-Allow-Origin: *'); // Allow all domains. Adjust if you want to be more restrictive
//header('Content-Type: application/json'); // Set appropriate content type for JSON data

require 'config_livescores2024.php';

// Récupération des données
$category = $_GET['category'];
$round = $_GET['round'];

$sql = "SELECT if(b.serie,'Checked','') AS blocked, h1.valide, h1.categ AS category, h1.serie, h1.round, h1.heat, h1.ligne, h1.lycra, h1.srcrank, h1.srcheat, 
               IF(ISNULL(h2.concu), h1.concu, h2.concu) AS concu, 
               IF(ISNULL(h2.concu), h1.concname, h2.concname) AS nom, 
               IF(ISNULL(h2.concu), h1.conclub, h2.conclub) AS club, 
               h1.rank, h1.total
        FROM (SELECT heats.*,concu.nom AS concname, concu.club AS conclub FROM heats LEFT JOIN concu ON heats.concu=concu.numpart ) h1
        LEFT JOIN (SELECT heats.*,concu.nom AS concname, concu.club AS conclub FROM heats LEFT JOIN concu ON heats.concu=concu.numpart ) h2 ON h2.heat = h1.srcheat AND h2.rank = h1.srcrank AND h1.categ = h2.categ
        LEFT JOIN (SELECT DISTINCT serie FROM bloque) b ON b.serie = h1.serie
        WHERE h1.categ = ? AND h1.round = ?
        ORDER BY h1.serie, h1.ligne";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ss", $category, $round);
$stmt->execute();
$result = $stmt->get_result();

// Transformation des données
$heatsData = [];
while ($row = $result->fetch_assoc()) {
    $serie = $row['serie'];
    $heat = $row['heat'];
    $valide = $row['valide'];  // Récupérer l'état du toggle

    if (!isset($heatsData[$serie])) {
        $heatsData[$serie] = [];
    }

    if (!isset($heatsData[$serie][$heat])) {
        $heatsData[$serie][$heat] = [];
    }

    $heatsData[$serie][$heat][] = [
        'blocked' => $row['blocked'],
        'lycra' => $row['lycra'],
        'ligne' => $row['ligne'],
        'concu' => $row['concu'],
        'nom' => $row['nom'],
        'club' => $row['club'],
        'srcrank' => $row['srcrank'],
        'srcheat' => $row['srcheat'],
        'rank' => $row['rank'],
        'total' => $row['total'],
        'valide' => $valide  // Ajouter l'état du toggle aux données
    ];
}

// Retourner les données en JSON
//echo json_encode(['heats' => $heatsData]);


$stmt->close();
$conn->close();

// Envoyer les données en JSON
echo json_encode($heatsData, JSON_PRETTY_PRINT);
?>