<?php
include_once 'auth.php';

// Inclure la connexion à la base de données
require_once 'config_livescores2024.php';

// Exécuter la requête pour les statistiques
$sql = "
   SELECT COUNT(c.numpart) AS nbre_concu,
           h1.nbre_series,
           h2.nbre_series_valide,
           m.best_score,
           w.best_wave, Consumed_time,total_time
    FROM concu c
    INNER JOIN
        (SELECT SUM(nbreheat) AS nbre_series FROM programme WHERE planifie=1) h1 ON 1=1
    INNER JOIN
        (SELECT COUNT(DISTINCT serie) AS nbre_series_valide FROM heats WHERE valide=1) h2 ON 1=1
    INNER JOIN
        (SELECT FORMAT(AVG(moyenne), 2) AS best_score FROM moyennes) m ON 1=1
    INNER JOIN
        (SELECT FORMAT(MAX(moyenne), 2) AS best_wave FROM moyennes_notes) w ON 1=1
    inner join
        (SELECT sum(if(valide>0,nbre,0)*duree) AS Consumed_time, sum(nbre*duree*planifie) AS total_time from

(SELECT valide, count(distinct serie) AS nbre,h.categ, h.`ROUND`,p.duree,p.nbreheat,p.planifie FROM heats h
LEFT JOIN programme p ON h.categ=p.categ AND h.`round`=p.`round`
GROUP BY h.categ, h.`round`,h.valide ) h1) h3 ON 1=1
";

$result = $conn->query($sql);

if ($result) {
    // Récupérer les données
    $stats = $result->fetch_assoc();
    // Envoyer les données en format JSON
    header('Content-Type: application/json');
    echo json_encode($stats);
} else {
    // En cas d'erreur, renvoyer un message d'erreur en JSON
    header('Content-Type: application/json');
    echo json_encode(['error' => 'Erreur lors de l\'exécution de la requête']);
}

$conn->close();
?>
